/*
 * Decompiled with CFR 0.152.
 */
package com.gprinter.command;

import android.graphics.Bitmap;
import android.text.TextUtils;
import android.util.Log;
import com.gprinter.utils.BitmapUtils;
import com.gprinter.utils.GpUtils;
import com.gprinter.zb.ZPLUtilities;
import com.gprinter.zb.ZebraImageI;
import com.gprinter.zb.ZebraImageInternal;
import java.io.UnsupportedEncodingException;
import java.util.Vector;

public class ZPLCommand {
    private static final String TAG = ZPLCommand.class.getSimpleName();
    Vector<Byte> Command = new Vector();

    public void addText(String font, Rotation rotation, int fontWidth, int fontHeight) {
        if (fontWidth < 10) {
            fontWidth = 10;
        } else if (fontWidth > 1500) {
            fontWidth = 1500;
        }
        if (fontHeight < 10) {
            fontHeight = 10;
        } else if (fontHeight > 1500) {
            fontHeight = 1500;
        }
        String str = font + "," + rotation.getValue() + "," + fontHeight + "," + fontWidth + "\r\n";
        this.addStrToCommand(str);
    }

    public void addChangeFont(String font, int fontHeight, int fontWidth) {
        if (fontHeight < 0) {
            fontHeight = 9;
        } else if (fontHeight > 9999) {
            fontHeight = 9;
        }
        if (fontWidth < 0) {
            fontWidth = 5;
        } else if (fontWidth > 9999) {
            fontWidth = 5;
        }
        String str = font + "," + fontHeight + "," + fontWidth + "\r\n";
        this.addStrToCommand(str);
    }

    public void addFW(Rotation rotation, Align align) {
        String str = "^FW" + rotation.getValue() + "," + align.getValue() + "\r\n";
        this.addStrToCommand(str);
    }

    public void addFont(int x, int y, String content) {
        String str = "^Fo" + x + "," + y + "^FD" + content + "^FS\r\n";
        this.addStrToCommand(str);
    }

    public void addSelectFont(Font font, Rotation rotation, int fontH, int fontW, int x, int y, String content) {
        String str = font.getValue() + "," + rotation.getValue() + "," + fontH + "," + fontW + "^Fo" + x + "," + y + "^FD" + content + "^FS\r\n";
        this.addStrToCommand(str);
    }

    public void addFontSN(int x, int y, String content, int add, CodeMark codeMark) {
        String str = "^Fo" + x + "," + y + "^SN" + content + "," + add + "," + codeMark.getValue() + "^FS\r\n";
        this.addStrToCommand(str);
    }

    public void addAztecCode(Rotation a, Scale b, CodeMark c, int d, CodeMark e, int f, int g) {
        String barCode = "^B0" + a.getValue() + "," + b.getValue() + "," + c.getValue() + "," + d + "," + (Object)((Object)e) + "," + f + "," + g;
        this.addStrToCommand(barCode);
    }

    public void addCode11(Rotation o, CodeMark e, int h, CodeMark f, CodeMark g) {
        if (h > 9999) {
            h = 9999;
        } else if (h < 1) {
            h = 1;
        }
        String barCode = "^B1" + o.getValue() + "," + e.getValue() + "," + h + "," + f.getValue() + "," + g.getValue();
        this.addStrToCommand(barCode);
    }

    public void addCrossCode(Rotation o, int h, CodeMark f, CodeMark g, CodeMark e) {
        if (h > 9999) {
            h = 9999;
        } else if (h < 1) {
            h = 1;
        }
        String barCode = "^B2" + o.getValue() + "," + h + "," + f.getValue() + "," + g.getValue() + "," + e.getValue();
        this.addStrToCommand(barCode);
    }

    public void addCode39(Rotation o, CodeMark e, int h, CodeMark f, CodeMark g) {
        if (h > 9999) {
            h = 9999;
        } else if (h < 1) {
            h = 1;
        }
        String barCode = "^B3" + o.getValue() + "," + e.getValue() + "," + h + f.getValue() + "," + g.getValue();
        this.addStrToCommand(barCode);
    }

    public void addCode49(Rotation o, int h, Identifier f, Mode m) {
        if (h > 9999) {
            h = 9999;
        } else if (h < 1) {
            h = 1;
        }
        String barCode = "^B4" + o.getValue() + "," + h + "," + f.getValue() + "," + m.getValue();
        this.addStrToCommand(barCode);
    }

    public void addCodePlanet(Rotation o, int h, CodeMark f, CodeMark g) {
        if (h > 9999) {
            h = 9999;
        } else if (h < 1) {
            h = 1;
        }
        String barCode = "^B5" + o.getValue() + "," + h + "," + f.getValue() + "," + g.getValue();
        this.addStrToCommand(barCode);
    }

    public void addPDF417(Rotation o, int h, EC s, int c, int r, CodeMark t) {
        if (c > 30) {
            c = 30;
        } else if (c < 1) {
            c = 1;
        }
        if (r > 30) {
            r = 30;
        } else if (r < 1) {
            r = 1;
        }
        if (h > 9999) {
            h = 9999;
        } else if (h < 1) {
            h = 1;
        }
        String barCode = "^B7" + o.getValue() + "," + h + "," + s.getValue() + "," + c + "," + r + "," + t.getValue();
        this.addStrToCommand(barCode);
    }

    public void addEAN8(Rotation o, int h, CodeMark f, CodeMark g) {
        if (h > 9999) {
            h = 9999;
        } else if (h < 1) {
            h = 1;
        }
        String barCode = "^B8" + o.getValue() + "," + h + "," + f.getValue() + "," + g.getValue();
        this.addStrToCommand(barCode);
    }

    public void addUPCE(Rotation o, int h, CodeMark f, CodeMark g, CodeMark e) {
        if (h > 9999) {
            h = 9999;
        } else if (h < 1) {
            h = 1;
        }
        String barCode = "^B9" + o.getValue() + "," + h + "," + f.getValue() + "," + g.getValue() + "," + e.getValue();
        this.addStrToCommand(barCode);
    }

    public void addCode93(Rotation o, int h, CodeMark f, CodeMark g, CodeMark e) {
        if (h > 9999) {
            h = 9999;
        } else if (h < 1) {
            h = 1;
        }
        String barCode = "^BA" + o.getValue() + "," + h + "," + f.getValue() + "," + g.getValue() + "," + e.getValue();
        this.addStrToCommand(barCode);
    }

    public void addCode128(Rotation o, int h, CodeMark f, CodeMark g, CodeMark e, Code128Mode m) {
        if (h > 9999) {
            h = 9999;
        } else if (h < 1) {
            h = 1;
        }
        String barCode = "^BC" + o.getValue() + "," + h + "," + f.getValue() + "," + g.getValue() + "," + e.getValue() + "," + m.getValue();
        this.addStrToCommand(barCode);
    }

    public void addEAN113(Rotation o, int h, CodeMark f, CodeMark g) {
        if (h > 9999) {
            h = 9999;
        } else if (h < 1) {
            h = 1;
        }
        String barCode = "^BE" + o.getValue() + "," + h + "," + f.getValue() + "," + g.getValue();
        this.addStrToCommand(barCode);
    }

    public void addMicroPDF417(Rotation o, int h, int m) {
        if (h > 9999) {
            h = 9999;
        } else if (h < 1) {
            h = 1;
        }
        if (m > 33) {
            m = 33;
        } else if (m < 0) {
            m = 0;
        }
        String barCode = "^BF" + o.getValue() + "," + h + "," + m;
        this.addStrToCommand(barCode);
    }

    public void addCodeI25(Rotation o, int h, CodeMark f, CodeMark g) {
        if (h > 9999) {
            h = 9999;
        } else if (h < 1) {
            h = 1;
        }
        String barCode = "^BI" + o.getValue() + "," + h + "," + f.getValue() + "," + g.getValue();
        this.addStrToCommand(barCode);
    }

    public void addCodeJ25(Rotation o, int h, CodeMark f, CodeMark g) {
        if (h > 9999) {
            h = 9999;
        } else if (h < 1) {
            h = 1;
        }
        String barCode = "^BJ" + o.getValue() + "," + h + "," + f.getValue() + "," + g.getValue();
        this.addStrToCommand(barCode);
    }

    public void addCodabar(Rotation o, CodeMark e, int h, CodeMark f, CodeMark g, StartCharacter k, StartCharacter I) {
        if (h > 9999) {
            h = 9999;
        } else if (h < 1) {
            h = 1;
        }
        String barCode = "^BK" + o.getValue() + "," + e.getValue() + "," + h + "," + f.getValue() + "," + g.getValue() + "," + k.getValue() + "," + I.getValue();
        this.addStrToCommand(barCode);
    }

    public void addLogMars(Rotation o, int h, CodeMark g) {
        if (h > 9999) {
            h = 9999;
        } else if (h < 1) {
            h = 1;
        }
        String barCode = "^BL" + o.getValue() + "," + h + "," + g.getValue();
        this.addStrToCommand(barCode);
    }

    public void addStart() {
        String str = "^XA\r\n";
        this.addStrToCommand(str);
    }

    public void addEnd() {
        String str = "^XZ\r\n";
        this.addStrToCommand(str);
    }

    public void addMapClear(CodeMark c) {
        String str = "^MC" + c.value + "\r\n";
        this.addStrToCommand(str);
    }

    public void addPrintDirection(Orientation orientation) {
        String str = "^PO" + orientation.getValue() + "\r\n";
        this.addStrToCommand(str);
    }

    public void addPrintMirror(CodeMark codeMark) {
        String str = "^PM" + codeMark.getValue() + "\r\n";
        this.addStrToCommand(str);
    }

    public void addPrintSpeed(Speed speed) {
        String str = "^PR" + speed.getValue() + "\r\n";
        this.addStrToCommand(str);
    }

    public void addPrintDarkness(Darkness darkness) {
        String str = "~SD" + darkness.getValue() + "\r\n";
        this.addStrToCommand(str);
    }

    public void addPageType(PageType pageType) {
        String str = "^MN" + pageType.getValue() + "\r\n";
        this.addStrToCommand(str);
    }

    public void addMediaType(MediaType mediaType) {
        String str = "^MT" + mediaType.getValue() + "\r\n";
        this.addStrToCommand(str);
    }

    public void addPrintMode(PrintMode printMode, CodeMark codeMark) {
        String str = "^MM" + printMode.getValue() + "," + (Object)((Object)codeMark) + "\r\n";
        this.addStrToCommand(str);
    }

    public void addTearPosition(int position) {
        if (position > 120) {
            position = 120;
        }
        if (position < -120) {
            position = -120;
        }
        String str = "~TA" + position + "\r\n";
        this.addStrToCommand(str);
    }

    public void addLabelHome(int x, int y) {
        String str = "^LH" + x + "," + y + "\r\n";
        this.addStrToCommand(str);
    }

    public void addLabelTop(int x) {
        if (x > 120) {
            x = 120;
        }
        if (x < -120) {
            x = -120;
        }
        String str = "^LT" + x + "\r\n";
        this.addStrToCommand(str);
    }

    public void addRePrint(CodeMark codeMark) {
        String str = "^JZ" + codeMark.getValue() + "\r\n";
        this.addStrToCommand(str);
    }

    public void addReversePrint(CodeMark codeMark) {
        String str = "^LR" + codeMark.getValue() + "\r\n";
        this.addStrToCommand(str);
    }

    public void addLabelWidth(int width) {
        String str = "^PW" + width + "\r\n";
        this.addStrToCommand(str);
    }

    public void addLabelLength(int length) {
        String str = "^LL" + length + "\r\n";
        this.addStrToCommand(str);
    }

    public void addBox(int x, int y, int w, int h, int t) {
        String str = "^FO" + x + "," + y + "^GB" + w + "," + h + "," + t + "^FS\r\n";
        this.addStrToCommand(str);
    }

    public void addDownloadBitmap(Bitmap bitmap, String name, int nWidth) {
        if (bitmap == null || bitmap.isRecycled() || bitmap.getWidth() < 1 || bitmap.getHeight() < 1) {
            if (bitmap == null) {
                Log.e((String)TAG, (String)"bitmap can not be null", (Throwable)new NullPointerException());
                return;
            }
            if (bitmap.isRecycled()) {
                Log.e((String)TAG, (String)"bitmap is recycled", (Throwable)new IllegalStateException());
                return;
            }
            Log.e((String)TAG, (String)"bitmap width or height canot be less than 1", (Throwable)new IllegalStateException());
            return;
        }
        int width = (nWidth + 7) / 8 * 8;
        int height = bitmap.getHeight() * width / bitmap.getWidth();
        Bitmap grayBitmap = GpUtils.toGrayscale(bitmap);
        Bitmap rszBitmap = GpUtils.resizeImage(grayBitmap, width, height);
        byte[] src = BitmapUtils.getCompressedBinaryzationBytes(rszBitmap, true);
        String data = this.toHexString1(src);
        if (TextUtils.isEmpty((CharSequence)name)) {
            name = "Test.GRF";
        }
        String str = "~DG" + name + "," + src.length + "," + width / 8 + "," + data + "\r\n";
        this.addStrToCommand(str);
    }

    public void printDownloadBitmap(int x, int y, String name, int xScale, int yScale) {
        String str = "^Fo" + x + "," + y + "^XG" + name + "," + xScale + "," + yScale + "^FS\r\n";
        this.addStrToCommand(str);
    }

    public String toHexString1(byte[] b) {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < b.length; ++i) {
            buffer.append(this.toHexString2(b[i]));
        }
        return buffer.toString();
    }

    public String toHexString2(byte b) {
        String s = Integer.toHexString(b & 0xFF);
        if (s.length() == 1) {
            return "0" + s.toUpperCase();
        }
        return s.toUpperCase();
    }

    private String getBodyHeader(int var1, int var2, boolean var3, int var4, int var5) {
        StringBuffer var6 = new StringBuffer();
        var6.append("^FO");
        var6.append(var1);
        var6.append(",");
        var6.append(var2);
        var6.append("^GFA");
        var6.append(",");
        var6.append(var5);
        var6.append(",");
        var6.append(var5);
        var6.append(",");
        var6.append(var4);
        var6.append(",");
        String var7 = var6.toString();
        if (!var3) {
            var7 = "^XA" + var7;
        }
        return var7;
    }

    protected ZebraImageInternal scaleImage(int var1, int var2, ZebraImageInternal var3) {
        var3.scaleImage(var1, var2);
        return var3;
    }

    public void printImage(ZebraImageI var1, int var2, int var3, int var4, int var5, boolean var6) {
        ZebraImageInternal var7 = this.scaleImage(var4, var5, (ZebraImageInternal)var1);
        int var8 = (var7.getWidth() + 7) / 8;
        int var9 = var8 * var7.getHeight();
        String var10 = this.getBodyHeader(var2, var3, var6, var8, var9);
        String var11 = ZPLUtilities.replaceAllWithInternalCharacters(var10);
        this.addStrToCommand(var11);
        this.getDitheredImage(var7);
        if (!var6) {
            String var14 = ZPLUtilities.decorateWithFormatPrefix("^XZ");
            this.addStrToCommand(var14);
        }
    }

    public void getDitheredImage(ZebraImageInternal Image) {
        int w = Image.getWidth();
        int h = Image.getHeight();
        this.getDitheredImage(w, h, Image);
    }

    protected void getDitheredImage(int width, int height, ZebraImageInternal var2) {
        int i;
        int[] w = var2.getRow(0);
        int[] h = var2.getRow(1);
        int ww = width / 8 + (width % 8 == 0 ? 0 : 1);
        int pix = 8 - width % 8;
        if (pix == 8) {
            pix = 0;
        }
        byte[] var8 = new byte[ww];
        int var9 = 0;
        for (i = 0; i < width; ++i) {
            w[i] = ZPLCommand.convertByteToGrayscale(w[i]);
        }
        for (i = 0; i < height; ++i) {
            int var11;
            for (var11 = 0; var11 < var8.length; ++var11) {
                var8[var11] = 0;
            }
            var11 = 0;
            for (int var12 = 0; var12 < width; ++var12) {
                if (var12 % 8 == 0) {
                    var9 = -128;
                }
                int var13 = w[var12];
                var11 = var12 / 8;
                int var14 = var13 >= 128 ? -1 : 0;
                var8[var11] = (byte)(var8[var11] | var9 & var14);
                int var15 = var13 - (var14 & 0xFF);
                if (var12 < width - 1) {
                    int n = var12 + 1;
                    w[n] = w[n] + 7 * var15 / 16;
                }
                if (var12 > 0 && i < height - 1) {
                    int n = var12 - 1;
                    h[n] = h[n] + 3 * var15 / 16;
                }
                if (i < height - 1) {
                    if (var12 == 0) {
                        h[var12] = ZPLCommand.convertByteToGrayscale(h[var12]);
                    }
                    int n = var12;
                    h[n] = h[n] + 5 * var15 / 16;
                }
                if (i < height - 1 && var12 < width - 1) {
                    h[var12 + 1] = ZPLCommand.convertByteToGrayscale(h[var12 + 1]);
                    int n = var12 + 1;
                    h[n] = h[n] + 1 * var15 / 16;
                }
                var9 = (byte)((var9 & 0xFF) >>> 1);
            }
            var8[var11] = (byte)(var8[var11] | 255 >>> 8 - pix);
            this.addUserCommand(var8);
            w = h;
            h = var2.getRow(i + 2);
        }
    }

    private static int convertByteToGrayscale(int var0) {
        int r = (var0 & 0xFF0000) >>> 16;
        int g = (var0 & 0xFF00) >>> 8;
        int b = var0 & 0xFF;
        int gray = (r * 30 + g * 59 + b * 11) / 100;
        if (gray > 255) {
            gray = 255;
        } else if (gray < 0) {
            gray = 0;
        }
        return gray;
    }

    public void addSelfTest() {
        String str = "~WC\r\n";
        this.addStrToCommand(str);
    }

    private void addStrToCommand(String str) {
        byte[] bs = null;
        if (!str.equals("")) {
            try {
                bs = str.getBytes("GB18030");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            for (int i = 0; i < bs.length; ++i) {
                this.Command.add(bs[i]);
            }
        }
    }

    public void addUserCommand(byte[] bytes) {
        if (bytes != null) {
            for (int i = 0; i < bytes.length; ++i) {
                this.Command.add(bytes[i]);
            }
        }
    }

    public void addUserCommand(String string) {
        if (!TextUtils.isEmpty((CharSequence)string)) {
            byte[] bytes = new byte[]{};
            try {
                bytes = string.getBytes("GB18030");
                for (int i = 0; i < bytes.length; ++i) {
                    this.Command.add(bytes[i]);
                }
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
    }

    public Vector<Byte> getCommand() {
        return this.Command;
    }

    public void addUserCommand(String string, String charsetName) throws UnsupportedEncodingException {
        if (!TextUtils.isEmpty((CharSequence)string)) {
            byte[] bytes = string.getBytes(charsetName);
            for (int i = 0; i < bytes.length; ++i) {
                this.Command.add(bytes[i]);
            }
        }
    }

    public static enum EC {
        EC_1(1),
        EC(2),
        EC_3(3),
        EC_4(4),
        EC_5(5),
        EC_6(6),
        EC_7(7),
        EC_8(8);

        private final int value;

        private EC(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum Scale {
        SCALE_1(1),
        SCALE_2(2),
        SCALE_3(3),
        SCALE_4(4),
        SCALE_5(5),
        SCALE_6(6),
        SCALE_7(7),
        SCALE_8(8),
        SCALE_9(9),
        SCALE_10(10);

        private final int value;

        private Scale(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum StartCharacter {
        A("A"),
        B("B"),
        C("C"),
        D("D"),
        E("E"),
        N("N"),
        T("C"),
        STAR("*");

        private final String value;

        private StartCharacter(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static enum Code128Mode {
        N("N"),
        U("U"),
        A("A"),
        D("D");

        private final String value;

        private Code128Mode(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static enum Mode {
        Mode_A("A"),
        Mode_0("0"),
        Mode_1("1"),
        Mode_2("2"),
        Mode_3("3"),
        Mode_4("4"),
        Mode_5("5");

        private final String value;

        private Mode(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static enum Identifier {
        N("N"),
        A("A"),
        B("B");

        private final String value;

        private Identifier(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static enum Orientation {
        Orientation_N("N"),
        Orientation_I("I");

        private final String value;

        private Orientation(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static enum CodeMark {
        Mark_N("N"),
        Mark_Y("Y");

        private final String value;

        private CodeMark(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static enum PrintMode {
        PrintMode_T("T"),
        PrintMode_P("P"),
        PrintMode_R("R"),
        PrintMode_A("A"),
        PrintMode_C("C"),
        PrintMode_D("D"),
        PrintMode_F("D"),
        PrintMode_L("L"),
        PrintMode_U("U"),
        PrintMode_K("K");

        private final String value;

        private PrintMode(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static enum MediaType {
        MediaType_T("T"),
        MediaType_D("D");

        private final String value;

        private MediaType(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static enum PageType {
        PageType_N("N"),
        PageType_Y("Y"),
        PageType_W("W"),
        PageType_M("M"),
        PageType_A("A");

        private final String value;

        private PageType(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static enum Darkness {
        Darkness_0("0"),
        Darkness_1("1"),
        Darkness_2("2"),
        Darkness_3("3"),
        Darkness_4("4"),
        Darkness_5("5"),
        Darkness_6("6"),
        Darkness_7("7"),
        Darkness_8("8"),
        Darkness_9("9"),
        Darkness_10("10"),
        Darkness_11("11"),
        Darkness_12("12"),
        Darkness_13("13"),
        Darkness_14("14"),
        Darkness_15("15"),
        Darkness_16("16"),
        Darkness_17("17"),
        Darkness_18("18"),
        Darkness_19("19"),
        Darkness_20("20"),
        Darkness_21("21"),
        Darkness_22("22"),
        Darkness_23("23"),
        Darkness_24("24"),
        Darkness_25("25"),
        Darkness_26("26"),
        Darkness_27("27"),
        Darkness_28("28"),
        Darkness_29("29"),
        Darkness_30("30");

        private final String value;

        private Darkness(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static enum Speed {
        SPEED_2("2"),
        SPEED_3("3"),
        SPEED_4("4"),
        SPEED_5("5"),
        SPEED_6("6"),
        SPEED_7("6"),
        SPEED_8("8");

        private final String value;

        private Speed(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static enum Align {
        Align_0("0"),
        Align_1("1"),
        Align_2("2");

        private final String value;

        private Align(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static enum Rotation {
        ROTATION_0("N"),
        ROTATION_90("R"),
        ROTATION_180("I"),
        ROTATION_270("B");

        private final String value;

        private Rotation(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static enum Font {
        FONT_A("^AA"),
        FONT_B("^AB"),
        FONT_C("^AC"),
        FONT_D("^AD"),
        FONT_E("^AE"),
        FONT_F("^AF"),
        FONT_G("^AG"),
        FONT_H("^AH"),
        FONT_BI("^AI"),
        FONT_J("^AJ"),
        FONT_K("^AK"),
        FONT_L("^AL"),
        FONT_M("^AM"),
        FONT_N("^AN"),
        FONT_O("^AO"),
        FONT_P("^AP"),
        FONT_Q("^AQ"),
        FONT_R("^AR"),
        FONT_S("^AS"),
        FONT_T("^AT"),
        FONT_U("^AU"),
        FONT_V("^AV"),
        FONT_W("^AW"),
        FONT_X("^AX"),
        FONT_Y("^AY"),
        FONT_Z("^AZ"),
        FONT_0("^A0"),
        FONT_1("^A1"),
        FONT_2("^A2"),
        FONT_3("^A3"),
        FONT_4("^A4"),
        FONT_5("^A5"),
        FONT_6("^A6"),
        FONT_7("^A7"),
        FONT_8("^A8"),
        FONT_9("^A9");

        private final String value;

        private Font(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

